<?php
session_start();
if (!isset($_SESSION['email'])) {
  header("Location: login.html");
  exit;
}

$conn = new mysqli("localhost", "root", "", "feed");
$email = $_SESSION['email'];

$stmt = $conn->prepare("SELECT * FROM records WHERE email=?");
$stmt->bind_param("s", $email);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>User Dashboard</title>
<style>
  body { font-family: Arial; background: #f5f5f5; text-align: center; }
  table { margin: 20px auto; border-collapse: collapse; background: white; width: 60%; }
  th, td { border: 1px solid #ccc; padding: 10px; text-align: left; }
  th { background: #eee; }
  button { margin: 8px; padding: 8px 14px; border: none; border-radius: 5px; cursor: pointer; color: white; }
  .print { background: #ff9800; }
  .pdf { background: #4CAF50; }
  .jpg { background: #2196F3; }
  .logout { background: #f44336; }
</style>
</head>
<body>

<h2>👋 Welcome, <?php echo htmlspecialchars($user['name']); ?></h2>


<table id="userTable" style="margin-top:40px">
  <tr><th>ID</th><td><?php echo $user['id']; ?></td></tr>
  <tr><th>Name</th><td><?php echo htmlspecialchars($user['name']); ?></td></tr>
  <tr><th>Email</th><td><?php echo htmlspecialchars($user['email']); ?></td></tr>
  <tr><th>Phone</th><td><?php echo htmlspecialchars($user['number']); ?></td></tr>
  <tr><th>Address</th><td><?php echo htmlspecialchars($user['code']); ?></td></tr>
</table>

<button class="print" onclick="window.print()">🖨️ Print</button>
<button class="pdf" onclick="downloadPDF()">📄 Download PDF</button>
<button class="jpg" onclick="downloadImage()">🖼️ Download JPG/PNG</button>

<form action="logout.php" method="POST" style="display:inline;">
  <button class="logout">🚪 Logout</button>
</form>

<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>

<script>
async function downloadPDF() {
  const { jsPDF } = window.jspdf;
  const pdf = new jsPDF();
  pdf.text("User Information", 20, 20);
  pdf.text("Name: <?php echo $user['name']; ?>", 20, 40);
  pdf.text("Email: <?php echo $user['email']; ?>", 20, 50);
  pdf.text("Number: <?php echo $user['number']; ?>", 20, 60);
  pdf.text("Zip Code: <?php echo $user['code']; ?>", 20, 70);
  pdf.save("user_data.pdf");
}

function downloadImage() {
  html2canvas(document.body).then(canvas => {
    const link = document.createElement('a');
    link.download = 'user_data.jpg';
    link.href = canvas.toDataURL("image/jpeg");
    link.click();
  });
}
</script>

</body>
</html>
